using System;
using System.Collections.Generic;

class Program
{
    static double CalculateOvertakingTime(int N, int K, List<int> positions, List<int> speeds)
    {
        List<double> overtakingTimes = new List<double>();

        for (int i = 0; i < N - 1; i++)
        {
            for (int j = i + 1; j < N; j++)
            {
                if (speeds[i] > speeds[j])
                {
                    double overtakingTime = (double)(positions[j] - positions[i]) / (speeds[i] - speeds[j]);
                    overtakingTimes.Add(overtakingTime);
                }
            }
        }

        overtakingTimes.Sort();
        return overtakingTimes[K - 1];
    }

    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int K = int.Parse(input[1]);

        List<int> positions = new List<int>();
        List<int> speeds = new List<int>();

        for (int i = 0; i < N; i++)
        {
            input = Console.ReadLine().Split();
            int x = int.Parse(input[0]);
            int v = int.Parse(input[1]);
            positions.Add(x);
            speeds.Add(v);
        }

        double result = CalculateOvertakingTime(N, K, positions, speeds);
        Console.WriteLine(result.ToString("F9")); 
    }
}